﻿/*
	VERSION:		1.2
	
	USAGE:
		#include "talk.as"
		player_mc.talk_obj = makeTalk( player_mc,  player_mc.image_mc,  spriteLayer_mc );
		
	PARAMETERS:
		player_mc				Player's movieClip.  Needed for position.
		playerImage_mc		Player's sprite system.  Needed for direction.
		spriteLayer_mc		Sprite movieClip.  Needed to search for sprites.  This can also be an array of references.
		
	SETTINGS:
		talk_key				The "talk" button.
		
	WHAT THIS DOES:
		This calls the  talk()  function 
		within whatever movieClip is in front of the player.
*/
makeTalk = function( player_mc, playerImage_mc, spriteLayer_mc, talkKey )
{
	// resolve optional parameters
	talkKey = (talkKey) ? talkKey : Key.SPACE;
	
	// create container
	var _this = new Object();
	
	// store parameters
	_this.player_mc = player_mc;
	_this.playerImage_mc = playerImage_mc;
	_this.spriteLayer_mc = spriteLayer_mc;
	
	// settings
	_this.talk_key = talkKey;
	
	// prevent repeated talking
	_this.lastKey = false;
	
	
	_this.loop = function()
	{
		if( Key.isDown(_this.talk_key) )
		{
			if( _this.lastKey == false )
			{
				_this.lastKey = true;
				// get direction
				switch( _this.playerImage_mc.direction )
				{
					case 0:		// up
						var x = 0;
						var y = -1;
					break;
					case 1:		// right
						var x = 1;
						var y = 0;
					break;
					case 2:		// down
						var x = 0;
						var y = 1;
					break;
					case 3:		// left
						var x = -1;
						var y = 0;
					break;
				}// switch:  direction
				
				// set the search location
				var xSearch = _this.player_mc._x  +  8  +  (x*16);
				var ySearch = _this.player_mc._y  +  8  +  (y*16);
				
				// detect sprite
				for( var nam in _this.spriteLayer_mc )
				{
					var thisSprite = _this.spriteLayer_mc[nam];
					if( xSearch > thisSprite._x  &&
						ySearch > thisSprite._y  &&
						xSearch < thisSprite._x+16  &&
						ySearch < thisSprite._y+16 )
					{
						// make that sprite talk
						//trace("talking to: "+nam);
						thisSprite.talk();
					}// if:  sprite detected
				}// for...in:  sprite layer
			}// if:  talk_key wasn't already being held
		}// if:  talk_key
		else
		{// if:  talk_key is NOT being pressed
			_this.lastKey = false;
		}// if:  talk_key is NOT being pressed
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 33 );		// 30 FPS
	
	
	
	// return this system
	return _this;
}// makeTalk()